﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。

''' <summary>
'''用于存储字符串值和启用附加验证的自定义类
''' </summary>
''' <remarks>有效字符串长度小于 256 个字符</remarks>
Friend Class ValidatedString

    '内部变量
    Dim m_value As String = ""
    Dim m_isValid As Boolean = True

    '定义 & 运算符，其作用就像字符串的 & 运算符一样。
    Public Shared Operator &(ByVal s1 As ValidatedString, ByVal s2 As ValidatedString) As ValidatedString
        Dim concatString As String = s1.Value & s2.Value

        Return New ValidatedString(concatString)
    End Operator

    ' ToString 现在将返回 Value 属性值。
    Public Overrides Function ToString() As String
        Return Me.Value.ToString
    End Function

    Public Sub New(ByVal value As String)
        Me.Value = value
    End Sub

    Public Property Value() As String
        Get
            Return Me.m_value
        End Get
        '** 将属性 setter 标记为私有，因为我们希望运行自定义验证
        '代码，但不希望公开公共 setter。
        Private Set(ByVal value As String)
            Me.m_value = value

            '设置值以后，执行验证并设置标志。
            Me.m_isValid = Validate()
        End Set
    End Property

    '用于测试值的长度是否小于等于 255 的自定义属性。
    Public ReadOnly Property IsValid() As Boolean
        Get
            Return Validate()
        End Get
    End Property

    Private Function Validate() As Boolean
        If Me.m_value.Length <= 255 Then
            Return True
        Else
            Return False
        End If
    End Function

End Class